package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SearchKeywordsProductSearch {
  private String locale;

  private List<SearchKeywordProductSearch> searchKeywords;

  public SearchKeywordsProductSearch() {
  }

  public SearchKeywordsProductSearch(String locale,
      List<SearchKeywordProductSearch> searchKeywords) {
    this.locale = locale;
    this.searchKeywords = searchKeywords;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public List<SearchKeywordProductSearch> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SearchKeywordProductSearch> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  @Override
  public String toString() {
    return "SearchKeywordsProductSearch{locale='" + locale + "', searchKeywords='" + searchKeywords + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchKeywordsProductSearch that = (SearchKeywordsProductSearch) o;
    return Objects.equals(locale, that.locale) &&
        Objects.equals(searchKeywords, that.searchKeywords);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale, searchKeywords);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    private List<SearchKeywordProductSearch> searchKeywords;

    public SearchKeywordsProductSearch build() {
      SearchKeywordsProductSearch result = new SearchKeywordsProductSearch();
      result.locale = this.locale;
      result.searchKeywords = this.searchKeywords;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder searchKeywords(List<SearchKeywordProductSearch> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }
  }
}
