package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SelectionOfProduct {
  private Reference productSelectionRef;

  private ProductSelection productSelection;

  private ProductVariantSelection variantSelection;

  private ProductVariantExclusion variantExclusion;

  private OffsetDateTime createdAt;

  public SelectionOfProduct() {
  }

  public SelectionOfProduct(Reference productSelectionRef, ProductSelection productSelection,
      ProductVariantSelection variantSelection, ProductVariantExclusion variantExclusion,
      OffsetDateTime createdAt) {
    this.productSelectionRef = productSelectionRef;
    this.productSelection = productSelection;
    this.variantSelection = variantSelection;
    this.variantExclusion = variantExclusion;
    this.createdAt = createdAt;
  }

  public Reference getProductSelectionRef() {
    return productSelectionRef;
  }

  public void setProductSelectionRef(Reference productSelectionRef) {
    this.productSelectionRef = productSelectionRef;
  }

  public ProductSelection getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ProductSelection productSelection) {
    this.productSelection = productSelection;
  }

  public ProductVariantSelection getVariantSelection() {
    return variantSelection;
  }

  public void setVariantSelection(ProductVariantSelection variantSelection) {
    this.variantSelection = variantSelection;
  }

  public ProductVariantExclusion getVariantExclusion() {
    return variantExclusion;
  }

  public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
    this.variantExclusion = variantExclusion;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  @Override
  public String toString() {
    return "SelectionOfProduct{productSelectionRef='" + productSelectionRef + "', productSelection='" + productSelection + "', variantSelection='" + variantSelection + "', variantExclusion='" + variantExclusion + "', createdAt='" + createdAt + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SelectionOfProduct that = (SelectionOfProduct) o;
    return Objects.equals(productSelectionRef, that.productSelectionRef) &&
        Objects.equals(productSelection, that.productSelection) &&
        Objects.equals(variantSelection, that.variantSelection) &&
        Objects.equals(variantExclusion, that.variantExclusion) &&
        Objects.equals(createdAt, that.createdAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelectionRef, productSelection, variantSelection, variantExclusion, createdAt);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference productSelectionRef;

    private ProductSelection productSelection;

    private ProductVariantSelection variantSelection;

    private ProductVariantExclusion variantExclusion;

    private OffsetDateTime createdAt;

    public SelectionOfProduct build() {
      SelectionOfProduct result = new SelectionOfProduct();
      result.productSelectionRef = this.productSelectionRef;
      result.productSelection = this.productSelection;
      result.variantSelection = this.variantSelection;
      result.variantExclusion = this.variantExclusion;
      result.createdAt = this.createdAt;
      return result;
    }

    public Builder productSelectionRef(Reference productSelectionRef) {
      this.productSelectionRef = productSelectionRef;
      return this;
    }

    public Builder productSelection(ProductSelection productSelection) {
      this.productSelection = productSelection;
      return this;
    }

    public Builder variantSelection(ProductVariantSelection variantSelection) {
      this.variantSelection = variantSelection;
      return this;
    }

    public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
      this.variantExclusion = variantExclusion;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }
  }
}
