package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetApprovalRuleApprovers {
  private ApproverHierarchyDraft approvers;

  public SetApprovalRuleApprovers() {
  }

  public SetApprovalRuleApprovers(ApproverHierarchyDraft approvers) {
    this.approvers = approvers;
  }

  public ApproverHierarchyDraft getApprovers() {
    return approvers;
  }

  public void setApprovers(ApproverHierarchyDraft approvers) {
    this.approvers = approvers;
  }

  @Override
  public String toString() {
    return "SetApprovalRuleApprovers{approvers='" + approvers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetApprovalRuleApprovers that = (SetApprovalRuleApprovers) o;
    return Objects.equals(approvers, that.approvers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approvers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApproverHierarchyDraft approvers;

    public SetApprovalRuleApprovers build() {
      SetApprovalRuleApprovers result = new SetApprovalRuleApprovers();
      result.approvers = this.approvers;
      return result;
    }

    public Builder approvers(ApproverHierarchyDraft approvers) {
      this.approvers = approvers;
      return this;
    }
  }
}
