package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetApprovalRuleRequesters {
  private List<RuleRequesterDraft> requesters;

  public SetApprovalRuleRequesters() {
  }

  public SetApprovalRuleRequesters(List<RuleRequesterDraft> requesters) {
    this.requesters = requesters;
  }

  public List<RuleRequesterDraft> getRequesters() {
    return requesters;
  }

  public void setRequesters(List<RuleRequesterDraft> requesters) {
    this.requesters = requesters;
  }

  @Override
  public String toString() {
    return "SetApprovalRuleRequesters{requesters='" + requesters + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetApprovalRuleRequesters that = (SetApprovalRuleRequesters) o;
    return Objects.equals(requesters, that.requesters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requesters);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<RuleRequesterDraft> requesters;

    public SetApprovalRuleRequesters build() {
      SetApprovalRuleRequesters result = new SetApprovalRuleRequesters();
      result.requesters = this.requesters;
      return result;
    }

    public Builder requesters(List<RuleRequesterDraft> requesters) {
      this.requesters = requesters;
      return this;
    }
  }
}
