package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetApprovalRuleStatus {
  private ApprovalRuleStatus status;

  public SetApprovalRuleStatus() {
  }

  public SetApprovalRuleStatus(ApprovalRuleStatus status) {
    this.status = status;
  }

  public ApprovalRuleStatus getStatus() {
    return status;
  }

  public void setStatus(ApprovalRuleStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "SetApprovalRuleStatus{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetApprovalRuleStatus that = (SetApprovalRuleStatus) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApprovalRuleStatus status;

    public SetApprovalRuleStatus build() {
      SetApprovalRuleStatus result = new SetApprovalRuleStatus();
      result.status = this.status;
      return result;
    }

    public Builder status(ApprovalRuleStatus status) {
      this.status = status;
      return this;
    }
  }
}
