package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetAttributeDefinitionType implements com.commercetools.graphql.api.types.AttributeDefinitionType {
  private AttributeDefinitionType elementType;

  private String name;

  public SetAttributeDefinitionType() {
  }

  public SetAttributeDefinitionType(AttributeDefinitionType elementType, String name) {
    this.elementType = elementType;
    this.name = name;
  }

  public AttributeDefinitionType getElementType() {
    return elementType;
  }

  public void setElementType(AttributeDefinitionType elementType) {
    this.elementType = elementType;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "SetAttributeDefinitionType{elementType='" + elementType + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetAttributeDefinitionType that = (SetAttributeDefinitionType) o;
    return Objects.equals(elementType, that.elementType) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementType, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeDefinitionType elementType;

    private String name;

    public SetAttributeDefinitionType build() {
      SetAttributeDefinitionType result = new SetAttributeDefinitionType();
      result.elementType = this.elementType;
      result.name = this.name;
      return result;
    }

    public Builder elementType(AttributeDefinitionType elementType) {
      this.elementType = elementType;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
