package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetBusinessUnitAssociates {
  private List<AssociateDraft> associates = Collections.emptyList();

  public SetBusinessUnitAssociates() {
  }

  public SetBusinessUnitAssociates(List<AssociateDraft> associates) {
    this.associates = associates;
  }

  public List<AssociateDraft> getAssociates() {
    return associates;
  }

  public void setAssociates(List<AssociateDraft> associates) {
    this.associates = associates;
  }

  @Override
  public String toString() {
    return "SetBusinessUnitAssociates{associates='" + associates + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetBusinessUnitAssociates that = (SetBusinessUnitAssociates) o;
    return Objects.equals(associates, that.associates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associates);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<AssociateDraft> associates = Collections.emptyList();

    public SetBusinessUnitAssociates build() {
      SetBusinessUnitAssociates result = new SetBusinessUnitAssociates();
      result.associates = this.associates;
      return result;
    }

    public Builder associates(List<AssociateDraft> associates) {
      this.associates = associates;
      return this;
    }
  }
}
