package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCartDirectDiscounts {
  private List<DirectDiscountDraft> discounts;

  public SetCartDirectDiscounts() {
  }

  public SetCartDirectDiscounts(List<DirectDiscountDraft> discounts) {
    this.discounts = discounts;
  }

  public List<DirectDiscountDraft> getDiscounts() {
    return discounts;
  }

  public void setDiscounts(List<DirectDiscountDraft> discounts) {
    this.discounts = discounts;
  }

  @Override
  public String toString() {
    return "SetCartDirectDiscounts{discounts='" + discounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartDirectDiscounts that = (SetCartDirectDiscounts) o;
    return Objects.equals(discounts, that.discounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<DirectDiscountDraft> discounts;

    public SetCartDirectDiscounts build() {
      SetCartDirectDiscounts result = new SetCartDirectDiscounts();
      result.discounts = this.discounts;
      return result;
    }

    public Builder discounts(List<DirectDiscountDraft> discounts) {
      this.discounts = discounts;
      return this;
    }
  }
}
