package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCartDiscountDescription {
  private List<LocalizedStringItemInputType> description;

  public SetCartDiscountDescription() {
  }

  public SetCartDiscountDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return "SetCartDiscountDescription{description='" + description + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartDiscountDescription that = (SetCartDiscountDescription) o;
    return Objects.equals(description, that.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> description;

    public SetCartDiscountDescription build() {
      SetCartDiscountDescription result = new SetCartDiscountDescription();
      result.description = this.description;
      return result;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }
  }
}
