package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetCartDiscountValidUntil {
  private OffsetDateTime validUntil;

  public SetCartDiscountValidUntil() {
  }

  public SetCartDiscountValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  @Override
  public String toString() {
    return "SetCartDiscountValidUntil{validUntil='" + validUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartDiscountValidUntil that = (SetCartDiscountValidUntil) o;
    return Objects.equals(validUntil, that.validUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validUntil;

    public SetCartDiscountValidUntil build() {
      SetCartDiscountValidUntil result = new SetCartDiscountValidUntil();
      result.validUntil = this.validUntil;
      return result;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }
  }
}
