package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemCustomField {
  private String lineItemId;

  private String name;

  private String value;

  private String lineItemKey;

  public SetCartLineItemCustomField() {
  }

  public SetCartLineItemCustomField(String lineItemId, String name, String value,
      String lineItemKey) {
    this.lineItemId = lineItemId;
    this.name = name;
    this.value = value;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemCustomField{lineItemId='" + lineItemId + "', name='" + name + "', value='" + value + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemCustomField that = (SetCartLineItemCustomField) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, name, value, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String name;

    private String value;

    private String lineItemKey;

    public SetCartLineItemCustomField build() {
      SetCartLineItemCustomField result = new SetCartLineItemCustomField();
      result.lineItemId = this.lineItemId;
      result.name = this.name;
      result.value = this.value;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
