package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemInventoryMode {
  private String lineItemId;

  private InventoryMode inventoryMode;

  private String lineItemKey;

  public SetCartLineItemInventoryMode() {
  }

  public SetCartLineItemInventoryMode(String lineItemId, InventoryMode inventoryMode,
      String lineItemKey) {
    this.lineItemId = lineItemId;
    this.inventoryMode = inventoryMode;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemInventoryMode{lineItemId='" + lineItemId + "', inventoryMode='" + inventoryMode + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemInventoryMode that = (SetCartLineItemInventoryMode) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, inventoryMode, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private InventoryMode inventoryMode;

    private String lineItemKey;

    public SetCartLineItemInventoryMode build() {
      SetCartLineItemInventoryMode result = new SetCartLineItemInventoryMode();
      result.lineItemId = this.lineItemId;
      result.inventoryMode = this.inventoryMode;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
