package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemSupplyChannel {
  private String lineItemId;

  private ResourceIdentifierInput supplyChannel;

  private String lineItemKey;

  public SetCartLineItemSupplyChannel() {
  }

  public SetCartLineItemSupplyChannel(String lineItemId, ResourceIdentifierInput supplyChannel,
      String lineItemKey) {
    this.lineItemId = lineItemId;
    this.supplyChannel = supplyChannel;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemSupplyChannel{lineItemId='" + lineItemId + "', supplyChannel='" + supplyChannel + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemSupplyChannel that = (SetCartLineItemSupplyChannel) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, supplyChannel, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ResourceIdentifierInput supplyChannel;

    private String lineItemKey;

    public SetCartLineItemSupplyChannel build() {
      SetCartLineItemSupplyChannel result = new SetCartLineItemSupplyChannel();
      result.lineItemId = this.lineItemId;
      result.supplyChannel = this.supplyChannel;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
