package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemTaxAmount {
  private String lineItemId;

  private ExternalTaxAmountDraft externalTaxAmount;

  private String shippingKey;

  private String lineItemKey;

  public SetCartLineItemTaxAmount() {
  }

  public SetCartLineItemTaxAmount(String lineItemId, ExternalTaxAmountDraft externalTaxAmount,
      String shippingKey, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.externalTaxAmount = externalTaxAmount;
    this.shippingKey = shippingKey;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ExternalTaxAmountDraft getExternalTaxAmount() {
    return externalTaxAmount;
  }

  public void setExternalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
    this.externalTaxAmount = externalTaxAmount;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemTaxAmount{lineItemId='" + lineItemId + "', externalTaxAmount='" + externalTaxAmount + "', shippingKey='" + shippingKey + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemTaxAmount that = (SetCartLineItemTaxAmount) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalTaxAmount, that.externalTaxAmount) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, externalTaxAmount, shippingKey, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ExternalTaxAmountDraft externalTaxAmount;

    private String shippingKey;

    private String lineItemKey;

    public SetCartLineItemTaxAmount build() {
      SetCartLineItemTaxAmount result = new SetCartLineItemTaxAmount();
      result.lineItemId = this.lineItemId;
      result.externalTaxAmount = this.externalTaxAmount;
      result.shippingKey = this.shippingKey;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
      this.externalTaxAmount = externalTaxAmount;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
