package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemTaxRate {
  private String lineItemId;

  private ExternalTaxRateDraft externalTaxRate;

  private String shippingKey;

  private String lineItemKey;

  public SetCartLineItemTaxRate() {
  }

  public SetCartLineItemTaxRate(String lineItemId, ExternalTaxRateDraft externalTaxRate,
      String shippingKey, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.externalTaxRate = externalTaxRate;
    this.shippingKey = shippingKey;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemTaxRate{lineItemId='" + lineItemId + "', externalTaxRate='" + externalTaxRate + "', shippingKey='" + shippingKey + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemTaxRate that = (SetCartLineItemTaxRate) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, externalTaxRate, shippingKey, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ExternalTaxRateDraft externalTaxRate;

    private String shippingKey;

    private String lineItemKey;

    public SetCartLineItemTaxRate build() {
      SetCartLineItemTaxRate result = new SetCartLineItemTaxRate();
      result.lineItemId = this.lineItemId;
      result.externalTaxRate = this.externalTaxRate;
      result.shippingKey = this.shippingKey;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
