package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLocale {
  private String locale;

  public SetCartLocale() {
  }

  public SetCartLocale(String locale) {
    this.locale = locale;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  @Override
  public String toString() {
    return "SetCartLocale{locale='" + locale + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLocale that = (SetCartLocale) o;
    return Objects.equals(locale, that.locale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    public SetCartLocale build() {
      SetCartLocale result = new SetCartLocale();
      result.locale = this.locale;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }
  }
}
