package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartShippingMethod {
  private ResourceIdentifierInput shippingMethod;

  private ExternalTaxRateDraft externalTaxRate;

  public SetCartShippingMethod() {
  }

  public SetCartShippingMethod(ResourceIdentifierInput shippingMethod,
      ExternalTaxRateDraft externalTaxRate) {
    this.shippingMethod = shippingMethod;
    this.externalTaxRate = externalTaxRate;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  @Override
  public String toString() {
    return "SetCartShippingMethod{shippingMethod='" + shippingMethod + "', externalTaxRate='" + externalTaxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartShippingMethod that = (SetCartShippingMethod) o;
    return Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(externalTaxRate, that.externalTaxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethod, externalTaxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput shippingMethod;

    private ExternalTaxRateDraft externalTaxRate;

    public SetCartShippingMethod build() {
      SetCartShippingMethod result = new SetCartShippingMethod();
      result.shippingMethod = this.shippingMethod;
      result.externalTaxRate = this.externalTaxRate;
      return result;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }
  }
}
