package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartShippingRateInput {
  private ShippingRateInputDraft shippingRateInput;

  public SetCartShippingRateInput() {
  }

  public SetCartShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  @Override
  public String toString() {
    return "SetCartShippingRateInput{shippingRateInput='" + shippingRateInput + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartShippingRateInput that = (SetCartShippingRateInput) o;
    return Objects.equals(shippingRateInput, that.shippingRateInput);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingRateInput);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingRateInputDraft shippingRateInput;

    public SetCartShippingRateInput build() {
      SetCartShippingRateInput result = new SetCartShippingRateInput();
      result.shippingRateInput = this.shippingRateInput;
      return result;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }
  }
}
