package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCategoryAssetCustomField {
  private String value;

  private String name;

  private String assetKey;

  private String assetId;

  public SetCategoryAssetCustomField() {
  }

  public SetCategoryAssetCustomField(String value, String name, String assetKey, String assetId) {
    this.value = value;
    this.name = name;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetCustomField{value='" + value + "', name='" + name + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetCustomField that = (SetCategoryAssetCustomField) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(name, that.name) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, name, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String value;

    private String name;

    private String assetKey;

    private String assetId;

    public SetCategoryAssetCustomField build() {
      SetCategoryAssetCustomField result = new SetCategoryAssetCustomField();
      result.value = this.value;
      result.name = this.name;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
