package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryAssetDescription {
  private List<LocalizedStringItemInputType> description;

  private String assetKey;

  private String assetId;

  public SetCategoryAssetDescription() {
  }

  public SetCategoryAssetDescription(List<LocalizedStringItemInputType> description,
      String assetKey, String assetId) {
    this.description = description;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetDescription{description='" + description + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetDescription that = (SetCategoryAssetDescription) o;
    return Objects.equals(description, that.description) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> description;

    private String assetKey;

    private String assetId;

    public SetCategoryAssetDescription build() {
      SetCategoryAssetDescription result = new SetCategoryAssetDescription();
      result.description = this.description;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
