package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCategoryAssetKey {
  private String assetKey;

  private String assetId;

  public SetCategoryAssetKey() {
  }

  public SetCategoryAssetKey(String assetKey, String assetId) {
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetKey{assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetKey that = (SetCategoryAssetKey) o;
    return Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String assetKey;

    private String assetId;

    public SetCategoryAssetKey build() {
      SetCategoryAssetKey result = new SetCategoryAssetKey();
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
