package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryMetaDescription {
  private List<LocalizedStringItemInputType> metaDescription;

  public SetCategoryMetaDescription() {
  }

  public SetCategoryMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  @Override
  public String toString() {
    return "SetCategoryMetaDescription{metaDescription='" + metaDescription + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryMetaDescription that = (SetCategoryMetaDescription) o;
    return Objects.equals(metaDescription, that.metaDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaDescription);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaDescription;

    public SetCategoryMetaDescription build() {
      SetCategoryMetaDescription result = new SetCategoryMetaDescription();
      result.metaDescription = this.metaDescription;
      return result;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }
  }
}
