package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryMetaKeywords {
  private List<LocalizedStringItemInputType> metaKeywords;

  public SetCategoryMetaKeywords() {
  }

  public SetCategoryMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  @Override
  public String toString() {
    return "SetCategoryMetaKeywords{metaKeywords='" + metaKeywords + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryMetaKeywords that = (SetCategoryMetaKeywords) o;
    return Objects.equals(metaKeywords, that.metaKeywords);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaKeywords);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaKeywords;

    public SetCategoryMetaKeywords build() {
      SetCategoryMetaKeywords result = new SetCategoryMetaKeywords();
      result.metaKeywords = this.metaKeywords;
      return result;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }
  }
}
