package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetChannelGeoLocation {
  private GeometryInput geoLocation;

  public SetChannelGeoLocation() {
  }

  public SetChannelGeoLocation(GeometryInput geoLocation) {
    this.geoLocation = geoLocation;
  }

  public GeometryInput getGeoLocation() {
    return geoLocation;
  }

  public void setGeoLocation(GeometryInput geoLocation) {
    this.geoLocation = geoLocation;
  }

  @Override
  public String toString() {
    return "SetChannelGeoLocation{geoLocation='" + geoLocation + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetChannelGeoLocation that = (SetChannelGeoLocation) o;
    return Objects.equals(geoLocation, that.geoLocation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoLocation);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private GeometryInput geoLocation;

    public SetChannelGeoLocation build() {
      SetChannelGeoLocation result = new SetChannelGeoLocation();
      result.geoLocation = this.geoLocation;
      return result;
    }

    public Builder geoLocation(GeometryInput geoLocation) {
      this.geoLocation = geoLocation;
      return this;
    }
  }
}
