package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetChannelRoles {
  private List<ChannelRole> roles;

  public SetChannelRoles() {
  }

  public SetChannelRoles(List<ChannelRole> roles) {
    this.roles = roles;
  }

  public List<ChannelRole> getRoles() {
    return roles;
  }

  public void setRoles(List<ChannelRole> roles) {
    this.roles = roles;
  }

  @Override
  public String toString() {
    return "SetChannelRoles{roles='" + roles + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetChannelRoles that = (SetChannelRoles) o;
    return Objects.equals(roles, that.roles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roles);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ChannelRole> roles;

    public SetChannelRoles build() {
      SetChannelRoles result = new SetChannelRoles();
      result.roles = this.roles;
      return result;
    }

    public Builder roles(List<ChannelRole> roles) {
      this.roles = roles;
      return this;
    }
  }
}
