package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerAddressCustomField {
  private String name;

  private String value;

  private String addressId;

  public SetCustomerAddressCustomField() {
  }

  public SetCustomerAddressCustomField(String name, String value, String addressId) {
    this.name = name;
    this.value = value;
    this.addressId = addressId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  @Override
  public String toString() {
    return "SetCustomerAddressCustomField{name='" + name + "', value='" + value + "', addressId='" + addressId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerAddressCustomField that = (SetCustomerAddressCustomField) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(addressId, that.addressId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, addressId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String value;

    private String addressId;

    public SetCustomerAddressCustomField build() {
      SetCustomerAddressCustomField result = new SetCustomerAddressCustomField();
      result.name = this.name;
      result.value = this.value;
      result.addressId = this.addressId;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }
  }
}
