package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerFirstName {
  private String firstName;

  public SetCustomerFirstName() {
  }

  public SetCustomerFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  @Override
  public String toString() {
    return "SetCustomerFirstName{firstName='" + firstName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerFirstName that = (SetCustomerFirstName) o;
    return Objects.equals(firstName, that.firstName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String firstName;

    public SetCustomerFirstName build() {
      SetCustomerFirstName result = new SetCustomerFirstName();
      result.firstName = this.firstName;
      return result;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }
  }
}
