package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerLastName {
  private String lastName;

  public SetCustomerLastName() {
  }

  public SetCustomerLastName(String lastName) {
    this.lastName = lastName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  @Override
  public String toString() {
    return "SetCustomerLastName{lastName='" + lastName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerLastName that = (SetCustomerLastName) o;
    return Objects.equals(lastName, that.lastName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lastName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lastName;

    public SetCustomerLastName build() {
      SetCustomerLastName result = new SetCustomerLastName();
      result.lastName = this.lastName;
      return result;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }
  }
}
