package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerSalutation {
  private String salutation;

  public SetCustomerSalutation() {
  }

  public SetCustomerSalutation(String salutation) {
    this.salutation = salutation;
  }

  public String getSalutation() {
    return salutation;
  }

  public void setSalutation(String salutation) {
    this.salutation = salutation;
  }

  @Override
  public String toString() {
    return "SetCustomerSalutation{salutation='" + salutation + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerSalutation that = (SetCustomerSalutation) o;
    return Objects.equals(salutation, that.salutation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salutation);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String salutation;

    public SetCustomerSalutation build() {
      SetCustomerSalutation result = new SetCustomerSalutation();
      result.salutation = this.salutation;
      return result;
    }

    public Builder salutation(String salutation) {
      this.salutation = salutation;
      return this;
    }
  }
}
