package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerVatId {
  private String vatId;

  public SetCustomerVatId() {
  }

  public SetCustomerVatId(String vatId) {
    this.vatId = vatId;
  }

  public String getVatId() {
    return vatId;
  }

  public void setVatId(String vatId) {
    this.vatId = vatId;
  }

  @Override
  public String toString() {
    return "SetCustomerVatId{vatId='" + vatId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerVatId that = (SetCustomerVatId) o;
    return Objects.equals(vatId, that.vatId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vatId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String vatId;

    public SetCustomerVatId build() {
      SetCustomerVatId result = new SetCustomerVatId();
      result.vatId = this.vatId;
      return result;
    }

    public Builder vatId(String vatId) {
      this.vatId = vatId;
      return this;
    }
  }
}
