package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetDiscountCodeCartPredicate {
  private String cartPredicate;

  public SetDiscountCodeCartPredicate() {
  }

  public SetDiscountCodeCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  @Override
  public String toString() {
    return "SetDiscountCodeCartPredicate{cartPredicate='" + cartPredicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetDiscountCodeCartPredicate that = (SetDiscountCodeCartPredicate) o;
    return Objects.equals(cartPredicate, that.cartPredicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartPredicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String cartPredicate;

    public SetDiscountCodeCartPredicate build() {
      SetDiscountCodeCartPredicate result = new SetDiscountCodeCartPredicate();
      result.cartPredicate = this.cartPredicate;
      return result;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }
  }
}
