package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetDiscountCodeMaxApplicationsPerCustomer {
  private Long maxApplicationsPerCustomer;

  public SetDiscountCodeMaxApplicationsPerCustomer() {
  }

  public SetDiscountCodeMaxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
  }

  public Long getMaxApplicationsPerCustomer() {
    return maxApplicationsPerCustomer;
  }

  public void setMaxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
    this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
  }

  @Override
  public String toString() {
    return "SetDiscountCodeMaxApplicationsPerCustomer{maxApplicationsPerCustomer='" + maxApplicationsPerCustomer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetDiscountCodeMaxApplicationsPerCustomer that = (SetDiscountCodeMaxApplicationsPerCustomer) o;
    return Objects.equals(maxApplicationsPerCustomer, that.maxApplicationsPerCustomer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxApplicationsPerCustomer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long maxApplicationsPerCustomer;

    public SetDiscountCodeMaxApplicationsPerCustomer build() {
      SetDiscountCodeMaxApplicationsPerCustomer result = new SetDiscountCodeMaxApplicationsPerCustomer();
      result.maxApplicationsPerCustomer = this.maxApplicationsPerCustomer;
      return result;
    }

    public Builder maxApplicationsPerCustomer(Long maxApplicationsPerCustomer) {
      this.maxApplicationsPerCustomer = maxApplicationsPerCustomer;
      return this;
    }
  }
}
