package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetExtensionTimeoutInMs {
  private Integer timeoutInMs;

  public SetExtensionTimeoutInMs() {
  }

  public SetExtensionTimeoutInMs(Integer timeoutInMs) {
    this.timeoutInMs = timeoutInMs;
  }

  public Integer getTimeoutInMs() {
    return timeoutInMs;
  }

  public void setTimeoutInMs(Integer timeoutInMs) {
    this.timeoutInMs = timeoutInMs;
  }

  @Override
  public String toString() {
    return "SetExtensionTimeoutInMs{timeoutInMs='" + timeoutInMs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetExtensionTimeoutInMs that = (SetExtensionTimeoutInMs) o;
    return Objects.equals(timeoutInMs, that.timeoutInMs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timeoutInMs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer timeoutInMs;

    public SetExtensionTimeoutInMs build() {
      SetExtensionTimeoutInMs result = new SetExtensionTimeoutInMs();
      result.timeoutInMs = this.timeoutInMs;
      return result;
    }

    public Builder timeoutInMs(Integer timeoutInMs) {
      this.timeoutInMs = timeoutInMs;
      return this;
    }
  }
}
