package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetInventoryEntryExpectedDelivery {
  private OffsetDateTime expectedDelivery;

  public SetInventoryEntryExpectedDelivery() {
  }

  public SetInventoryEntryExpectedDelivery(OffsetDateTime expectedDelivery) {
    this.expectedDelivery = expectedDelivery;
  }

  public OffsetDateTime getExpectedDelivery() {
    return expectedDelivery;
  }

  public void setExpectedDelivery(OffsetDateTime expectedDelivery) {
    this.expectedDelivery = expectedDelivery;
  }

  @Override
  public String toString() {
    return "SetInventoryEntryExpectedDelivery{expectedDelivery='" + expectedDelivery + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetInventoryEntryExpectedDelivery that = (SetInventoryEntryExpectedDelivery) o;
    return Objects.equals(expectedDelivery, that.expectedDelivery);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expectedDelivery);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime expectedDelivery;

    public SetInventoryEntryExpectedDelivery build() {
      SetInventoryEntryExpectedDelivery result = new SetInventoryEntryExpectedDelivery();
      result.expectedDelivery = this.expectedDelivery;
      return result;
    }

    public Builder expectedDelivery(OffsetDateTime expectedDelivery) {
      this.expectedDelivery = expectedDelivery;
      return this;
    }
  }
}
