package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetMyCartShippingMethod {
  private ResourceIdentifierInput shippingMethod;

  public SetMyCartShippingMethod() {
  }

  public SetMyCartShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  @Override
  public String toString() {
    return "SetMyCartShippingMethod{shippingMethod='" + shippingMethod + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetMyCartShippingMethod that = (SetMyCartShippingMethod) o;
    return Objects.equals(shippingMethod, that.shippingMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethod);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput shippingMethod;

    public SetMyCartShippingMethod build() {
      SetMyCartShippingMethod result = new SetMyCartShippingMethod();
      result.shippingMethod = this.shippingMethod;
      return result;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }
  }
}
