package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderEditComment {
  private String comment;

  public SetOrderEditComment() {
  }

  public SetOrderEditComment(String comment) {
    this.comment = comment;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  @Override
  public String toString() {
    return "SetOrderEditComment{comment='" + comment + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderEditComment that = (SetOrderEditComment) o;
    return Objects.equals(comment, that.comment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(comment);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String comment;

    public SetOrderEditComment build() {
      SetOrderEditComment result = new SetOrderEditComment();
      result.comment = this.comment;
      return result;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }
  }
}
