package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetOrderEditStagedActions {
  private List<StagedOrderUpdateAction> stagedActions;

  public SetOrderEditStagedActions() {
  }

  public SetOrderEditStagedActions(List<StagedOrderUpdateAction> stagedActions) {
    this.stagedActions = stagedActions;
  }

  public List<StagedOrderUpdateAction> getStagedActions() {
    return stagedActions;
  }

  public void setStagedActions(List<StagedOrderUpdateAction> stagedActions) {
    this.stagedActions = stagedActions;
  }

  @Override
  public String toString() {
    return "SetOrderEditStagedActions{stagedActions='" + stagedActions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderEditStagedActions that = (SetOrderEditStagedActions) o;
    return Objects.equals(stagedActions, that.stagedActions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stagedActions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<StagedOrderUpdateAction> stagedActions;

    public SetOrderEditStagedActions build() {
      SetOrderEditStagedActions result = new SetOrderEditStagedActions();
      result.stagedActions = this.stagedActions;
      return result;
    }

    public Builder stagedActions(List<StagedOrderUpdateAction> stagedActions) {
      this.stagedActions = stagedActions;
      return this;
    }
  }
}
