package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderItemShippingAddressCustomField {
  private String addressKey;

  private String name;

  private String value;

  public SetOrderItemShippingAddressCustomField() {
  }

  public SetOrderItemShippingAddressCustomField(String addressKey, String name, String value) {
    this.addressKey = addressKey;
    this.name = name;
    this.value = value;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetOrderItemShippingAddressCustomField{addressKey='" + addressKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderItemShippingAddressCustomField that = (SetOrderItemShippingAddressCustomField) o;
    return Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressKey;

    private String name;

    private String value;

    public SetOrderItemShippingAddressCustomField build() {
      SetOrderItemShippingAddressCustomField result = new SetOrderItemShippingAddressCustomField();
      result.addressKey = this.addressKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
