package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderLineItemShippingDetails {
  private String lineItemId;

  private ItemShippingDetailsDraftType shippingDetails;

  private String lineItemKey;

  public SetOrderLineItemShippingDetails() {
  }

  public SetOrderLineItemShippingDetails(String lineItemId,
      ItemShippingDetailsDraftType shippingDetails, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.shippingDetails = shippingDetails;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ItemShippingDetailsDraftType getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftType shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetOrderLineItemShippingDetails{lineItemId='" + lineItemId + "', shippingDetails='" + shippingDetails + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderLineItemShippingDetails that = (SetOrderLineItemShippingDetails) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, shippingDetails, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ItemShippingDetailsDraftType shippingDetails;

    private String lineItemKey;

    public SetOrderLineItemShippingDetails build() {
      SetOrderLineItemShippingDetails result = new SetOrderLineItemShippingDetails();
      result.lineItemId = this.lineItemId;
      result.shippingDetails = this.shippingDetails;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftType shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
