package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderReturnItemCustomField {
  private String name;

  private String value;

  private String returnItemId;

  private String returnItemKey;

  public SetOrderReturnItemCustomField() {
  }

  public SetOrderReturnItemCustomField(String name, String value, String returnItemId,
      String returnItemKey) {
    this.name = name;
    this.value = value;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  @Override
  public String toString() {
    return "SetOrderReturnItemCustomField{name='" + name + "', value='" + value + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderReturnItemCustomField that = (SetOrderReturnItemCustomField) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, returnItemId, returnItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String value;

    private String returnItemId;

    private String returnItemKey;

    public SetOrderReturnItemCustomField build() {
      SetOrderReturnItemCustomField result = new SetOrderReturnItemCustomField();
      result.name = this.name;
      result.value = this.value;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }
  }
}
