package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderShippingAddress {
  private AddressInput address;

  public SetOrderShippingAddress() {
  }

  public SetOrderShippingAddress(AddressInput address) {
    this.address = address;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  @Override
  public String toString() {
    return "SetOrderShippingAddress{address='" + address + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderShippingAddress that = (SetOrderShippingAddress) o;
    return Objects.equals(address, that.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddressInput address;

    public SetOrderShippingAddress build() {
      SetOrderShippingAddress result = new SetOrderShippingAddress();
      result.address = this.address;
      return result;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }
  }
}
