package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentAmountPaid {
  private MoneyInput amount;

  public SetPaymentAmountPaid() {
  }

  public SetPaymentAmountPaid(MoneyInput amount) {
    this.amount = amount;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  @Override
  public String toString() {
    return "SetPaymentAmountPaid{amount='" + amount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentAmountPaid that = (SetPaymentAmountPaid) o;
    return Objects.equals(amount, that.amount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput amount;

    public SetPaymentAmountPaid build() {
      SetPaymentAmountPaid result = new SetPaymentAmountPaid();
      result.amount = this.amount;
      return result;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }
  }
}
