package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentAnonymousId {
  private String anonymousId;

  public SetPaymentAnonymousId() {
  }

  public SetPaymentAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  @Override
  public String toString() {
    return "SetPaymentAnonymousId{anonymousId='" + anonymousId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentAnonymousId that = (SetPaymentAnonymousId) o;
    return Objects.equals(anonymousId, that.anonymousId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(anonymousId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String anonymousId;

    public SetPaymentAnonymousId build() {
      SetPaymentAnonymousId result = new SetPaymentAnonymousId();
      result.anonymousId = this.anonymousId;
      return result;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }
  }
}
