package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductAttributeInAllVariants {
  private String name;

  private String value;

  private Boolean staged = true;

  public SetProductAttributeInAllVariants() {
  }

  public SetProductAttributeInAllVariants(String name, String value, Boolean staged) {
    this.name = name;
    this.value = value;
    this.staged = staged;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductAttributeInAllVariants{name='" + name + "', value='" + value + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductAttributeInAllVariants that = (SetProductAttributeInAllVariants) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String value;

    private Boolean staged = true;

    public SetProductAttributeInAllVariants build() {
      SetProductAttributeInAllVariants result = new SetProductAttributeInAllVariants();
      result.name = this.name;
      result.value = this.value;
      result.staged = this.staged;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
