package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductDiscountedPrice {
  private String priceId;

  private DiscountedProductPriceValueInput discounted;

  private Boolean staged = true;

  public SetProductDiscountedPrice() {
  }

  public SetProductDiscountedPrice(String priceId, DiscountedProductPriceValueInput discounted,
      Boolean staged) {
    this.priceId = priceId;
    this.discounted = discounted;
    this.staged = staged;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public DiscountedProductPriceValueInput getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValueInput discounted) {
    this.discounted = discounted;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductDiscountedPrice{priceId='" + priceId + "', discounted='" + discounted + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductDiscountedPrice that = (SetProductDiscountedPrice) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, discounted, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private DiscountedProductPriceValueInput discounted;

    private Boolean staged = true;

    public SetProductDiscountedPrice build() {
      SetProductDiscountedPrice result = new SetProductDiscountedPrice();
      result.priceId = this.priceId;
      result.discounted = this.discounted;
      result.staged = this.staged;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValueInput discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
