package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductMetaKeywords {
  private List<LocalizedStringItemInputType> metaKeywords;

  private Boolean staged = true;

  public SetProductMetaKeywords() {
  }

  public SetProductMetaKeywords(List<LocalizedStringItemInputType> metaKeywords, Boolean staged) {
    this.metaKeywords = metaKeywords;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductMetaKeywords{metaKeywords='" + metaKeywords + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductMetaKeywords that = (SetProductMetaKeywords) o;
    return Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaKeywords, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaKeywords;

    private Boolean staged = true;

    public SetProductMetaKeywords build() {
      SetProductMetaKeywords result = new SetProductMetaKeywords();
      result.metaKeywords = this.metaKeywords;
      result.staged = this.staged;
      return result;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
