package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductMetaTitle {
  private List<LocalizedStringItemInputType> metaTitle;

  private Boolean staged = true;

  public SetProductMetaTitle() {
  }

  public SetProductMetaTitle(List<LocalizedStringItemInputType> metaTitle, Boolean staged) {
    this.metaTitle = metaTitle;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductMetaTitle{metaTitle='" + metaTitle + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductMetaTitle that = (SetProductMetaTitle) o;
    return Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaTitle, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaTitle;

    private Boolean staged = true;

    public SetProductMetaTitle build() {
      SetProductMetaTitle result = new SetProductMetaTitle();
      result.metaTitle = this.metaTitle;
      result.staged = this.staged;
      return result;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
