package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductPriceCustomField {
  private String priceId;

  private Boolean staged = true;

  private String name;

  private String value;

  public SetProductPriceCustomField() {
  }

  public SetProductPriceCustomField(String priceId, Boolean staged, String name, String value) {
    this.priceId = priceId;
    this.staged = staged;
    this.name = name;
    this.value = value;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetProductPriceCustomField{priceId='" + priceId + "', staged='" + staged + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductPriceCustomField that = (SetProductPriceCustomField) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, staged, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private Boolean staged = true;

    private String name;

    private String value;

    public SetProductPriceCustomField build() {
      SetProductPriceCustomField result = new SetProductPriceCustomField();
      result.priceId = this.priceId;
      result.staged = this.staged;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
