package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringAssetSources {
  private Integer variantId;

  private String sku;

  private Boolean staged = true;

  private List<AssetSourceInput> sources = Collections.emptyList();

  private String assetKey;

  private String assetId;

  public SetProductTailoringAssetSources() {
  }

  public SetProductTailoringAssetSources(Integer variantId, String sku, Boolean staged,
      List<AssetSourceInput> sources, String assetKey, String assetId) {
    this.variantId = variantId;
    this.sku = sku;
    this.staged = staged;
    this.sources = sources;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public List<AssetSourceInput> getSources() {
    return sources;
  }

  public void setSources(List<AssetSourceInput> sources) {
    this.sources = sources;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetProductTailoringAssetSources{variantId='" + variantId + "', sku='" + sku + "', staged='" + staged + "', sources='" + sources + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringAssetSources that = (SetProductTailoringAssetSources) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(sources, that.sources) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, staged, sources, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private Boolean staged = true;

    private List<AssetSourceInput> sources = Collections.emptyList();

    private String assetKey;

    private String assetId;

    public SetProductTailoringAssetSources build() {
      SetProductTailoringAssetSources result = new SetProductTailoringAssetSources();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.staged = this.staged;
      result.sources = this.sources;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder sources(List<AssetSourceInput> sources) {
      this.sources = sources;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
