package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringDescription {
  private List<LocalizedStringItemInputType> description;

  private Boolean staged = true;

  public SetProductTailoringDescription() {
  }

  public SetProductTailoringDescription(List<LocalizedStringItemInputType> description,
      Boolean staged) {
    this.description = description;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringDescription{description='" + description + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringDescription that = (SetProductTailoringDescription) o;
    return Objects.equals(description, that.description) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> description;

    private Boolean staged = true;

    public SetProductTailoringDescription build() {
      SetProductTailoringDescription result = new SetProductTailoringDescription();
      result.description = this.description;
      result.staged = this.staged;
      return result;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
